var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            "use strict";
            var Logger = (function () {
                function Logger() {
                    this._loggerProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.LoggerPortMarshaler", {
                    }, true);
                }
                Logger.prototype.info = function (message) {
                    this._loggerProxy._call("logInfo", message);
                };
                Logger.prototype.debug = function (message) {
                    this._loggerProxy._call("logDebug", message);
                };
                Logger.prototype.warning = function (message) {
                    this._loggerProxy._call("logWarning", message);
                };
                Logger.prototype.error = function (message) {
                    this._loggerProxy._call("logError", message);
                };
                return Logger;
            })();            
            var _logger = null;
            function getLogger() {
                if(_logger == null) {
                    _logger = new Logger();
                }
                return _logger;
            }
            DiagnosticsHub.getLogger = getLogger;
            Plugin.addEventListener("pluginready", function () {
                getLogger();
            });
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            "use strict";
            (function (SessionState) {
                SessionState._map = [];
                SessionState.Unknown = 0;
                SessionState.Created = 100;
                SessionState.LaunchConfiguration = 125;
                SessionState.SetupTargets = 150;
                SessionState.CollectionStarting = 200;
                SessionState.CollectionStarted = 300;
                SessionState.CollectionPausing = 325;
                SessionState.CollectionPauseCanceling = 330;
                SessionState.CollectionPaused = 350;
                SessionState.CollectionResuming = 375;
                SessionState.CollectionResumeCanceling = 380;
                SessionState.CollectionFinishing = 400;
                SessionState.CollectionFinished = 500;
                SessionState.CollectionTerminating = 600;
                SessionState.CollectionTerminated = 700;
                SessionState.CollectionStartFailed = 10000;
                SessionState.CollectionStartCanceling = 10100;
                SessionState.CollectionFinishFailed = 20000;
                SessionState.CollectionFinishCanceling = 20100;
                SessionState.SessionClosed = 100000;
            })(DiagnosticsHub.SessionState || (DiagnosticsHub.SessionState = {}));
            var SessionState = DiagnosticsHub.SessionState;
            var EventDeferral = (function () {
                function EventDeferral(onHandlerCompleted) {
                    this._onHandlerCompleted = onHandlerCompleted;
                }
                EventDeferral.prototype.complete = function () {
                    this._onHandlerCompleted();
                };
                return EventDeferral;
            })();            
            var StateChangedEventArgs = (function () {
                function StateChangedEventArgs(eventArgs, onHandlerCompleted) {
                    this._eventArgs = eventArgs;
                    this._waitHandler = false;
                    this._onHandlerCompleted = onHandlerCompleted;
                    this._eventDeferral = null;
                }
                Object.defineProperty(StateChangedEventArgs.prototype, "currentState", {
                    get: function () {
                        return this._eventArgs.CurrentState;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(StateChangedEventArgs.prototype, "previousState", {
                    get: function () {
                        return this._eventArgs.PreviousState;
                    },
                    enumerable: true,
                    configurable: true
                });
                StateChangedEventArgs.prototype.getDeferral = function () {
                    if(this._eventDeferral == null) {
                        this._eventDeferral = new EventDeferral(this._onHandlerCompleted);
                    }
                    return this._eventDeferral;
                };
                Object.defineProperty(StateChangedEventArgs.prototype, "waitHandler", {
                    get: function () {
                        return this._eventDeferral != null;
                    },
                    enumerable: true,
                    configurable: true
                });
                return StateChangedEventArgs;
            })();            
            var Session = (function () {
                function Session(logger) {
                    var that = this;
                    this._eventsListeners = new Array();
                    this._logger = logger;
                    this._sessionProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.SessionPortMarshaler", {
                    }, true);
                    this._sessionProxy._call("initialize").done(function () {
                        that._logger.debug("JavaScript session object connected to host. Ready to get session state notification events.");
                    }, function (error) {
                        that._logger.error("Cannot initialize session, error name: '" + error.name + "', error message: '" + error.message + "'");
                    });
                    this._sessionProxy.addEventListener("sessionStateChanged", function (eventArgs) {
                        that.stateChangedHandler(eventArgs);
                    });
                    try  {
                        var apex = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.Test.Apex.DiagnosticsHub.ApexJSExtension", {
                        }, true);
                        if(apex != null) {
                            apex._call("getApexJavaScript").done(function (result) {
                                var scriptObj = document.createElement("script");
                                scriptObj.setAttribute("type", "text/javascript");
                                scriptObj.setAttribute("src", result);
                                var head = document.getElementsByTagName("head");
                                if(!head) {
                                    that._logger.debug("Unable to add apex script to document");
                                } else {
                                    head[0].appendChild(scriptObj);
                                    that._logger.debug("Added ApexJSExtension '" + result + "' to document");
                                }
                            });
                        }
                    } catch (e) {
                        this._logger.error(e.toString());
                    }
                }
                Session.prototype.getState = function (callback, onError) {
                    var that = this;
                    this._logger.debug("Calling get state");
                    return this._sessionProxy._call("getState").done(function (result) {
                        that._logger.debug("On getstate done, state value: " + result);
                        if(callback != null) {
                            callback(result);
                        }
                    }, function (error) {
                        that._logger.error("Cannot get state, error name: '" + error.name + "', error message: '" + error.message + "'");
                        if(onError != null) {
                            onError(error);
                        }
                    });
                };
                Session.prototype.addStateChangedEventListener = function (listener) {
                    this._eventsListeners.push(listener);
                    this._logger.debug('State changed event handler added.');
                };
                Session.prototype.removeStateChangedEventListener = function (listener) {
                    for(var i = 0; i < this._eventsListeners.length; i++) {
                        if(this._eventsListeners[i] == listener) {
                            this._logger.debug('State changed event handler removed.');
                            this._eventsListeners.splice(i, 1);
                            break;
                        }
                    }
                };
                Session.prototype.stateChangedHandler = function (eventArgs) {
                    var that = this;
                    this._logger.debug('Invoking JavaScript handlers for State Change Event.');
                    var handlersCount = 0;
                    var onCompleted = function () {
                        handlersCount--;
                        if(handlersCount <= 0) {
                            that._sessionProxy._call("sessionStateChangedCompleted", eventArgs.Token);
                        } else {
                            that._logger.debug("Still waiting when all event state change handlers will complete their work. Handlers count: " + handlersCount);
                        }
                    };
                    for(var propertyName in this._eventsListeners) {
                        var handler = this._eventsListeners[propertyName];
                        if(this._eventsListeners.hasOwnProperty(propertyName)) {
                            if(typeof handler == 'function') {
                                try  {
                                    var jsEventArgs = new StateChangedEventArgs(eventArgs, onCompleted);
                                    handler(jsEventArgs);
                                    if(jsEventArgs.waitHandler) {
                                        handlersCount++;
                                        that._logger.debug("JavaScipt handlers for event state changed asked to wait while they will finish. Handlers count: " + handlersCount);
                                    }
                                } catch (e) {
                                    this._logger.error(e.toString());
                                }
                            } else {
                                this._logger.warning('One of the listeners not a "function", it has type ' + (typeof handler));
                            }
                        }
                    }
                    if(handlersCount == 0) {
                        onCompleted();
                    }
                };
                return Session;
            })();            
            var _currentSession = null;
            function getCurrentSession() {
                if(_currentSession == null) {
                    _currentSession = new Session(DiagnosticsHub.getLogger());
                }
                return _currentSession;
            }
            DiagnosticsHub.getCurrentSession = getCurrentSession;
            Plugin.addEventListener("pluginready", function () {
                getCurrentSession();
            });
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            "use strict";
            var EventAggregator = (function () {
                function EventAggregator(logger) {
                    this._eventsListeners = {
                    };
                    var that = this;
                    this._logger = logger;
                    this._eventAggregatorProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.EventAggregatorMarshaler", {
                    }, true);
                    this._eventAggregatorProxy.addEventListener("globalEventHandler", function (eventArgs) {
                        that.globalEventHandler(eventArgs);
                    });
                }
                EventAggregator.prototype.addEventListener = function (eventType, listener) {
                    if(typeof this._eventsListeners[eventType] == 'undefined') {
                        this._eventsListeners[eventType] = new Array();
                    }
                    this._eventsListeners[eventType].push(listener);
                    this._logger.debug('Event listener added.');
                };
                EventAggregator.prototype.removeEventListener = function (eventType, listener) {
                    if(typeof this._eventsListeners[eventType] != 'undefined') {
                        var subscribers = this._eventsListeners[eventType];
                        for(var i = 0; i < subscribers.length; i++) {
                            if(subscribers[i] == listener) {
                                this._logger.debug('Event listener removed.');
                                subscribers.splice(i, 1);
                                break;
                            }
                        }
                        if(subscribers.length == 0) {
                            delete this._eventsListeners[eventType];
                        }
                    }
                };
                EventAggregator.prototype.globalEventHandler = function (eventArgs) {
                    var eventType = eventArgs.EventType;
                    this._logger.debug('Handling event type ' + eventType + '.');
                    var listeners = this._eventsListeners[eventType];
                    if(typeof listeners != 'undefined') {
                        for(var propertyName in listeners) {
                            var handler = listeners[propertyName];
                            if(listeners.hasOwnProperty(propertyName)) {
                                if(typeof handler == 'function') {
                                    var dataString = eventArgs.HubEventArgs.Data;
                                    this._logger.debug('Raise handler for event type ' + eventType + ' with data ' + dataString + '.');
                                    try  {
                                        var data = null;
                                        if(dataString != null) {
                                            data = JSON.parse(dataString);
                                        }
                                        handler(data);
                                    } catch (e) {
                                        this._logger.error(e);
                                    }
                                } else {
                                    this._logger.warning('One of the listeners not a "function", it has type ' + (typeof handler));
                                }
                            }
                        }
                    } else {
                        this._logger.debug('Does not have listeners for event type ' + eventType + '.');
                    }
                };
                EventAggregator.prototype.raiseEvent = function (eventType, data) {
                    var dataString = null;
                    if(data != null) {
                        dataString = JSON.stringify(data);
                    }
                    this._logger.debug('Raising event type ' + eventType + ' with data ' + dataString + '.');
                    this._eventAggregatorProxy._call("raiseEvent", eventType, dataString);
                };
                return EventAggregator;
            })();            
            var _eventAggregator = null;
            function getEventAggregator() {
                if(_eventAggregator == null) {
                    _eventAggregator = new EventAggregator(DiagnosticsHub.getLogger());
                }
                return _eventAggregator;
            }
            DiagnosticsHub.getEventAggregator = getEventAggregator;
            Plugin.addEventListener("pluginready", function () {
                getEventAggregator();
            });
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            "use strict";
            var OutputWindowsService = (function () {
                function OutputWindowsService() {
                    this._loggerProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.OutputWindowServiceMarshaler", {
                    }, true);
                }
                OutputWindowsService.prototype.outputLine = function (message) {
                    this._loggerProxy._call("outputLine", message);
                };
                OutputWindowsService.prototype.outputLineAndShow = function (message) {
                    this._loggerProxy._call("outputLineAndShow", message);
                };
                OutputWindowsService.prototype.outputString = function (message) {
                    this._loggerProxy._call("outputString", message);
                };
                OutputWindowsService.prototype.outputStringAndShow = function (message) {
                    this._loggerProxy._call("outputStringAndShow", message);
                };
                return OutputWindowsService;
            })();            
            var _outputWindowService = null;
            function getOutputWindowsService() {
                if(_outputWindowService == null) {
                    _outputWindowService = new OutputWindowsService();
                }
                return _outputWindowService;
            }
            DiagnosticsHub.getOutputWindowsService = getOutputWindowsService;
            Plugin.addEventListener("pluginready", function () {
                getOutputWindowsService();
            });
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            (function (Collectors) {
                "use strict";
                var StandardTransportService = (function () {
                    function StandardTransportService(logger) {
                        var that = this;
                        this._messageListeners = {
                        };
                        this._logger = logger;
                        this._proxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.StandardTransportServicePortMarshaller", {
                        }, true);
                        this._proxy.addEventListener("stringMessageReceived", function (eventArgs) {
                            that._logger.debug("StandardTransportService.stringMessageReceived");
                            that.onStringMessageReceived(eventArgs);
                        });
                    }
                    StandardTransportService.prototype.getIsRemoteConnection = function () {
                        return this._proxy._call("getIsRemoteConnection");
                    };
                    StandardTransportService.prototype.sendStringToCollectionAgent = function (agentClassId, request) {
                        this._logger.debug("StandardTransportService.sendStringToCollectionAgent");
                        return this._proxy._call("sendStringToCollectionAgent", agentClassId, request);
                    };
                    StandardTransportService.prototype.downloadFile = function (targetFilePath, localFilePath) {
                        this._logger.debug("StandardTransportService.downloadFile");
                        return this._proxy._call("downloadFile", targetFilePath, localFilePath);
                    };
                    StandardTransportService.prototype.addMessageListener = function (listenerGuid, listener) {
                        var _this = this;
                        this._logger.debug("StandardTransportService.addMessageListener(" + listenerGuid + ")");
                        if(typeof listenerGuid != "string" || (listenerGuid.length != 38 && listenerGuid.length != 36)) {
                            throw new Error("'listenerGuid' must be a Guid string");
                        }
                        if(listenerGuid.length == 38 && listenerGuid[0] == '{' && listenerGuid[37] == '}') {
                            listenerGuid = listenerGuid.substr(1, 36);
                        }
                        listenerGuid = listenerGuid.toLowerCase();
                        var lowerCaseGuidRegEx = new RegExp("^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$");
                        if(!lowerCaseGuidRegEx.test(listenerGuid)) {
                            throw new Error("'listenerGuid' must be a Guid string");
                        }
                        if(this._messageListeners[listenerGuid]) {
                            throw new Error("Listener already exists with guid = " + listenerGuid);
                        }
                        this._messageListeners[listenerGuid] = listener;
                        return this._proxy._call("enableEventsForListenerId", listenerGuid).then(null, function (value) {
                            _this._messageListeners[listenerGuid] = null;
                        });
                    };
                    StandardTransportService.prototype.onStringMessageReceived = function (eventArgs) {
                        this._logger.debug('StandardTransportService.onStringMessageReceived');
                        var listenerGuid = eventArgs.ListenerId;
                        var message = eventArgs.Message;
                        if(this._messageListeners[listenerGuid]) {
                            var listener = this._messageListeners[listenerGuid];
                            listener(message);
                        } else {
                            this._logger.warning('Unexpected message recieved without a message listener. listenerGuid=' + listenerGuid);
                        }
                    };
                    return StandardTransportService;
                })();                
                var _standardTransportService = null;
                function getStandardTransportService() {
                    if(_standardTransportService == null) {
                        _standardTransportService = new StandardTransportService(DiagnosticsHub.getLogger());
                    }
                    return _standardTransportService;
                }
                Collectors.getStandardTransportService = getStandardTransportService;
            })(DiagnosticsHub.Collectors || (DiagnosticsHub.Collectors = {}));
            var Collectors = DiagnosticsHub.Collectors;
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            "use strict";
            var GraphDataUpdateService = (function () {
                function GraphDataUpdateService(logger) {
                    this._logger = logger;
                    this._serviceProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.GraphDataUpdateServiceMarshaler", {
                    }, true);
                }
                GraphDataUpdateService.prototype.addNewPoints = function (counterId, points) {
                    var that = this;
                    this._serviceProxy._call("addNewPoints", counterId, points).done(function () {
                    }, function (error) {
                        that._logger.error(error.message);
                    });
                };
                return GraphDataUpdateService;
            })();            
            var _graphDataUpdateService = null;
            function getGraphDataUpdateService() {
                if(_graphDataUpdateService == null) {
                    _graphDataUpdateService = new GraphDataUpdateService(DiagnosticsHub.getLogger());
                }
                return _graphDataUpdateService;
            }
            DiagnosticsHub.getGraphDataUpdateService = getGraphDataUpdateService;
            Plugin.addEventListener("pluginready", function () {
                getGraphDataUpdateService();
            });
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    (function (VisualStudio) {
        (function (DiagnosticsHub) {
            (function (DataWarehouse) {
                "use strict";
                var DataSourceIdentity = (function () {
                    function DataSourceIdentity() { }
                    DataSourceIdentity.EtlFile = "DiagnosticsHub.FileDataSource.EtlFile";
                    DataSourceIdentity.DiagnosticsPackage = "DiagnosticsHub.FileDataSource.DiagnosticsPackage";
                    DataSourceIdentity.Directory = "DiagnosticsHub.FileDataSource.Directory";
                    DataSourceIdentity.UnknownFile = "DiagnosticsHub.FileDataSource.UnknownFile";
                    return DataSourceIdentity;
                })();
                DataWarehouse.DataSourceIdentity = DataSourceIdentity;                
                (function (DataSourceInfoType) {
                    DataSourceInfoType._map = [];
                    DataSourceInfoType.Unknown = 0;
                    DataSourceInfoType.File = 1;
                    DataSourceInfoType.Directory = 2;
                    DataSourceInfoType.Package = 3;
                })(DataWarehouse.DataSourceInfoType || (DataWarehouse.DataSourceInfoType = {}));
                var DataSourceInfoType = DataWarehouse.DataSourceInfoType;
                var DataSourceInfo = (function () {
                    function DataSourceInfo(id, type, identity, path) {
                        this.id = id;
                        this.type = type;
                        this.identity = identity;
                        this.path = path;
                    }
                    return DataSourceInfo;
                })();
                DataWarehouse.DataSourceInfo = DataSourceInfo;                
                var DataWarehouseService = (function () {
                    function DataWarehouseService() {
                        this._serviceProxy = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.VisualStudio.Presentation.JavaScriptModels.DataWarehouseServiceMarshaler", {
                        }, true);
                        this._logger = DiagnosticsHub.getLogger();
                    }
                    DataWarehouseService.prototype.getAllDataSourceInfos = function (callback) {
                        var that = this;
                        this._serviceProxy._call("getAllDataSourceInfos").done(function (result) {
                            var infos = new Array();
                            for(var i = 0; i < result.length; i++) {
                                var dataSource = result[i];
                                if(dataSource.Type == DataSourceInfoType.File || dataSource.Type == DataSourceInfoType.Directory || dataSource.Type == DataSourceInfoType.Package) {
                                    infos.push(new DataSourceInfo(dataSource.Id, dataSource.Type, dataSource.Identity, dataSource.Path));
                                } else {
                                    that._logger.error("Unknown type of data source info type: " + dataSource.Type);
                                }
                            }
                            callback(infos);
                        });
                    };
                    return DataWarehouseService;
                })();                
                var _service = null;
                function getDataWarehouseService() {
                    if(_service == null) {
                        _service = new DataWarehouseService();
                    }
                    return _service;
                }
                DataWarehouse.getDataWarehouseService = getDataWarehouseService;
                Plugin.addEventListener("pluginready", function () {
                    getDataWarehouseService();
                });
            })(DiagnosticsHub.DataWarehouse || (DiagnosticsHub.DataWarehouse = {}));
            var DataWarehouse = DiagnosticsHub.DataWarehouse;
        })(VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
        var DiagnosticsHub = VisualStudio.DiagnosticsHub;
    })(Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
    var VisualStudio = Microsoft.VisualStudio;
})(Microsoft || (Microsoft = {}));
//@ sourceMappingURL=DiagnosticsHub.js.map

// SIG // Begin signature block
// SIG // MIIamQYJKoZIhvcNAQcCoIIaijCCGoYCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFJSq0HvJE0QS
// SIG // eDtP7bKTs32Hlf1joIIVeTCCBLowggOioAMCAQICCmEC
// SIG // kkoAAAAAACAwDQYJKoZIhvcNAQEFBQAwdzELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBMB4XDTEyMDEwOTIyMjU1OVoXDTEz
// SIG // MDQwOTIyMjU1OVowgbMxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // RFNFIEVTTjpCOEVDLTMwQTQtNzE0NDElMCMGA1UEAxMc
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCASIw
// SIG // DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM1jw/ei
// SIG // tUfZ+TmUU6xrj6Z5OCH00W49FTgWwXMsmY/74Dxb4aJM
// SIG // i7Kri7TySse5k1DRJvWHU7B6dfNHDxcrZyxk62DnSozg
// SIG // i17EVmk3OioEXRcByL+pt9PJq6ORqIHjPy232OTEeAB5
// SIG // Oc/9x2TiIxJ4ngx2J0mPmqwOdOMGVVVJyO2hfHBFYX6y
// SIG // cRYe4cFBudLSMulSJPM2UATX3W88SdUL1HZA/GVlE36V
// SIG // UTrV/7iap1drSxXlN1gf3AANxa7q34FH+fBSrubPWqzg
// SIG // FEqmcZSA+v2wIzBg6YNgrA4kHv8R8uelVWKV7p9/ninW
// SIG // zUsKdoPwQwTfBkkg8lNaRLBRejkCAwEAAaOCAQkwggEF
// SIG // MB0GA1UdDgQWBBTNGaxhTZRnK/avlHVZ2/BYAIOhOjAf
// SIG // BgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7syuwwzWzDzBU
// SIG // BgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vY3JsLm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsGAQUFBwEBBEww
// SIG // SjBIBggrBgEFBQcwAoY8aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRUaW1lU3Rh
// SIG // bXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQBRHNbfNh3cgLwCp8aZ3xbI
// SIG // kAZpFZoyufNkENKK82IpG3mPymCps13E5BYtNYxEm/H0
// SIG // XGGkQa6ai7pQ0Wp5arNijJ1NUVALqY7Uv6IQwEfVTnVS
// SIG // iR4/lmqPLkAUBnLuP3BZkl2F7YOZ+oKEnuQDASETqyfW
// SIG // zHFJ5dod/288CU7VjWboDMl/7jEUAjdfe2nsiT5FfyVE
// SIG // 5x8a1sUaw0rk4fGEmOdP+amYpxhG7IRs7KkDCv18elId
// SIG // nGukqA+YkqSSeFwreON9ssfZtnB931tzU7+q1GZQS/DJ
// SIG // O5WF5cFKZZ0lWFC7IFSReTobB1xqVyivMcef58Md7kf9
// SIG // J9d/z3TcZcU/MIIE7DCCA9SgAwIBAgITMwAAALARrwqL
// SIG // 0Duf3QABAAAAsDANBgkqhkiG9w0BAQUFADB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQTAeFw0xMzAxMjQyMjMzMzla
// SIG // Fw0xNDA0MjQyMjMzMzlaMIGDMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYDVQQDExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQDor1yiIA34KHy8BXt/re7r
// SIG // dqwoUz8620B9s44z5lc/pVEVNFSlz7SLqT+oN+EtUO01
// SIG // Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Unm/P4LZ5BNisL
// SIG // QPu+O7q5XHWTFlJLyjPFN7Dz636o9UEVXAhlHSE38Cy6
// SIG // IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpOoPXJCiHiquMB
// SIG // Nkf9L4JqgQP1qTXclFed+0vUDoLbOI8S/uPWenSIZOFi
// SIG // xCUuKq6dGB8OHrbCryS0DlC83hyTXEmmebW22875cHso
// SIG // AYS4KinPv6kFBeHgD3FN/a1cI4Mp68fFSsjoJ4TTfsZD
// SIG // C5UABbFPZXHFAgMBAAGjggFgMIIBXDATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGmWjNN2pgHgP+E
// SIG // Hr6H+XIyQfIwUQYDVR0RBEowSKRGMEQxDTALBgNVBAsT
// SIG // BE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRmYWYwYjcxLWFk
// SIG // MzctNGFhMy1hNjcxLTc2YmMwNTIzNDRhZDAfBgNVHSME
// SIG // GDAWgBTLEejK0rQWWAHJNy4zFha5TJoKHzBWBgNVHR8E
// SIG // TzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0Ff
// SIG // MDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUHAQEETjBMMEoG
// SIG // CCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NlcnRzL01pY0NvZFNpZ1BDQV8wOC0zMS0y
// SIG // MDEwLmNydDANBgkqhkiG9w0BAQUFAAOCAQEAMdduKhJX
// SIG // M4HVncbr+TrURE0Inu5e32pbt3nPApy8dmiekKGcC8N/
// SIG // oozxTbqVOfsN4OGb9F0kDxuNiBU6fNutzrPJbLo5LEV9
// SIG // JBFUJjANDf9H6gMH5eRmXSx7nR2pEPocsHTyT2lrnqkk
// SIG // hNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2yRPnwPJNtQtjo
// SIG // fOYXoJtoaAko+QKX7xEDumdSrcHps3Om0mPNSuI+5PNO
// SIG // /f+h4LsCEztdIN5VP6OukEAxOHUoXgSpRm3m9Xp5QL0f
// SIG // zehF1a7iXT71dcfmZmNgzNWahIeNJDD37zTQYx2xQmdK
// SIG // Dku/Og7vtpU6pzjkJZIIpohmgjCCBbwwggOkoAMCAQIC
// SIG // CmEzJhoAAAAAADEwDQYJKoZIhvcNAQEFBQAwXzETMBEG
// SIG // CgmSJomT8ixkARkWA2NvbTEZMBcGCgmSJomT8ixkARkW
// SIG // CW1pY3Jvc29mdDEtMCsGA1UEAxMkTWljcm9zb2Z0IFJv
// SIG // b3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MB4XDTEwMDgz
// SIG // MTIyMTkzMloXDTIwMDgzMTIyMjkzMloweTELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IENv
// SIG // ZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCycllcGTBkvx2aYCAgQpl2U2w+
// SIG // G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/3sJCTiPVcgDb
// SIG // NVcKicquIEn08GisTUuNpb15S3GbRwfa/SXfnXWIz6pz
// SIG // RH/XgdvzvfI2pMlcRdyvrT3gKGiXGqelcnNW8ReU5P01
// SIG // lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJpL9oZC/6SdCni
// SIG // di9U3RQwWfjSjWL9y8lfRjFQuScT5EAwz3IpECgixzdO
// SIG // PaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn0i1i8UU956wI
// SIG // APZGoZ7RW4wmU+h6qkryRs83PDietHdcpReejcsRj1Y8
// SIG // wawJXwPTAgMBAAGjggFeMIIBWjAPBgNVHRMBAf8EBTAD
// SIG // AQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGCNxUBBAUCAwEA
// SIG // ATAjBgkrBgEEAYI3FQIEFgQU/dExTtMmipXhmGA7qDFv
// SIG // pjy82C0wGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // HwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8KuEKU5VZ5KQw
// SIG // UAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvbWljcm9z
// SIG // b2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUFBwEBBEgwRjBE
// SIG // BggrBgEFBQcwAoY4aHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNyb3NvZnRSb290Q2VydC5j
// SIG // cnQwDQYJKoZIhvcNAQEFBQADggIBAFk5Pn8mRq/rb0Cx
// SIG // MrVq6w4vbqhJ9+tfde1MOy3XQ60L/svpLTGjI8x8UJiA
// SIG // IV2sPS9MuqKoVpzjcLu4tPh5tUly9z7qQX/K4QwXacul
// SIG // nCAt+gtQxFbNLeNK0rxw56gNogOlVuC4iktX8pVCnPHz
// SIG // 7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y4k74jKHK6BOl
// SIG // kU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wdzaKMvSeyeWNW
// SIG // RKJRzfnpo1hW3ZsCRUQvX/TartSCMm78pJUT5Otp56mi
// SIG // LL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q70eFW6NB4lhhc
// SIG // yTUWX92THUmOLb6tNEQc7hAVGgBd3TVbIc6YxwnuhQ6M
// SIG // T20OE049fClInHLR82zKwexwo1eSV32UjaAbSANa98+j
// SIG // Zwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKNMxZlHg6K3RDe
// SIG // ZPRvzkbU0xfpecQEtNP7LN8fip6sCvsTJ0Ct5PnhqX9G
// SIG // uwdgR2VgQE6wQuxO7bN2edgKNAltHIAxH+IOVN3lofvl
// SIG // RxCtZJj/UBYufL8FIXrilUEnacOTj5XJjdibIa4NXJzw
// SIG // oq6GaIMMai27dmsAHZat8hZ79haDJLmIz2qoRzEvmtzj
// SIG // cT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq/2mbluIQqBC0
// SIG // N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZoNAAAAAAAHDAN
// SIG // BgkqhkiG9w0BAQUFADBfMRMwEQYKCZImiZPyLGQBGRYD
// SIG // Y29tMRkwFwYKCZImiZPyLGQBGRYJbWljcm9zb2Z0MS0w
// SIG // KwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0
// SIG // ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1MzA5WhcNMjEw
// SIG // NDAzMTMwMzA5WjB3MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEw
// SIG // HwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Ew
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCf
// SIG // oWyx39tIkip8ay4Z4b3i48WZUSNQrc7dGE4kD+7Rp9FM
// SIG // rXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr6Hu97IkHD/cO
// SIG // BJjwicwfyzMkh53y9GccLPx754gd6udOo6HBI1PKjfpF
// SIG // zwnQXq/QsEIEovmmbJNn1yjcRlOwhtDlKEYuJ6yGT1VS
// SIG // DOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd++NIT8wi3U21S
// SIG // tEWQn0gASkdmEScpZqiX5NMGgUqi+YSnEUcUCYKfhO1V
// SIG // eP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68eeEExd8yb3zuD
// SIG // k6FhArUdDbH895uyAc4iS1T/+QXDwiALAgMBAAGjggGr
// SIG // MIIBpzAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQj
// SIG // NPjZUkZwCu1A+3b7syuwwzWzDzALBgNVHQ8EBAMCAYYw
// SIG // EAYJKwYBBAGCNxUBBAMCAQAwgZgGA1UdIwSBkDCBjYAU
// SIG // DqyCYEBWJ5flJRP8KuEKU5VZ5KShY6RhMF8xEzARBgoJ
// SIG // kiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/IsZAEZFglt
// SIG // aWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBSb290
// SIG // IENlcnRpZmljYXRlIEF1dGhvcml0eYIQea0WoUqgpa1M
// SIG // c1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9taWNyb3NvZnRyb290Y2VydC5jcmwwVAYIKwYBBQUH
// SIG // AQEESDBGMEQGCCsGAQUFBzAChjhodHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY3Jvc29mdFJv
// SIG // b3RDZXJ0LmNydDATBgNVHSUEDDAKBggrBgEFBQcDCDAN
// SIG // BgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wDRDbd6bStd9vO
// SIG // eVFNAbEudHFbbQwTq86+e4+4LtQSooxtYrhXAstOIBNQ
// SIG // md16QOJXu69YmhzhHQGGrLt48ovQ7DsB7uK+jwoFyI1I
// SIG // 4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mRKiQicPv2/OR4
// SIG // mS4N9wficLwYTp2OawpylbihOZxnLcVRDupiXD8WmIsg
// SIG // P+IHGjL5zDFKdjE9K3ILyOpwPf+FChPfwgphjvDXuBfr
// SIG // Tot/xTUrXqO/67x9C0J71FNyIe4wyrt4ZVxbARcKFA7S
// SIG // 2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGysOUzU9nm/qhh6
// SIG // YinvopspNAZ3GmLJPR5tH4LwC8csu89Ds+X57H2146So
// SIG // dDW4TsVxIxImdgs8UoxxWkZDFLyzs7BNZ8ifQv+AeSGA
// SIG // nhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU2DKATCYqSCRf
// SIG // WupW76bemZ3KOm+9gSd0BhHudiG/m4LBJ1S2sWo9iaF2
// SIG // YbRuoROmv6pH8BJv/YoybLL+31HIjCPJZr2dHYcSZAI9
// SIG // La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCleKuzoJZ1GtmS
// SIG // hxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/Jmu5J4PcBZW+J
// SIG // C33Iacjmbuqnl84xKf8OxVtc2E0bodj6L54/LlUWa8kT
// SIG // o/0xggSMMIIEiAIBATCBkDB5MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWdu
// SIG // aW5nIFBDQQITMwAAALARrwqL0Duf3QABAAAAsDAJBgUr
// SIG // DgMCGgUAoIGuMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3
// SIG // AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEV
// SIG // MCMGCSqGSIb3DQEJBDEWBBQQFPYFibV0gKl9v/Xw5phh
// SIG // vukcJDBOBgorBgEEAYI3AgEMMUAwPqAkgCIARABpAGEA
// SIG // ZwBuAG8AcwB0AGkAYwBzAEgAdQBiAC4AagBzoRaAFGh0
// SIG // dHA6Ly9taWNyb3NvZnQuY29tMA0GCSqGSIb3DQEBAQUA
// SIG // BIIBACNix0zFmAOnM+uGpyyiT92OejTtjUVx5NieR+Ts
// SIG // 8EDmqeLeoiQNI9EhhbC2qVEwYHcOyrQkMhtYd8Vj6q4E
// SIG // 5kTCHT2cjNhYZkF6J8Lv8r68WyAqIgmqfi80Guk0eNMP
// SIG // QCPDpkfJOsjY2AFexwwwivHdrzgIFlX5+xZri9nerZlf
// SIG // hbGNjWZbT+iU7TmpylZ46sBvFumQnCnzlAZC9LZhZgKi
// SIG // DefNEvpySxVKArfi9dgQX5Ek9JQoUEwin2TRFzUWwyQS
// SIG // L7IgNpViyvNhkWMrg8CYR42ikQqqaUcIfZvx3E2Q8t4S
// SIG // YCgBNMjDo9gUwISjEnRUPBmZyZ1nR2JcnwGUORShggIf
// SIG // MIICGwYJKoZIhvcNAQkGMYICDDCCAggCAQEwgYUwdzEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9z
// SIG // b2Z0IFRpbWUtU3RhbXAgUENBAgphApJKAAAAAAAgMAkG
// SIG // BSsOAwIaBQCgXTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcN
// SIG // AQcBMBwGCSqGSIb3DQEJBTEPFw0xMzAzMTUwNjM0MDJa
// SIG // MCMGCSqGSIb3DQEJBDEWBBS0RyiiqROXLli97lzC2Cnh
// SIG // zthG7zANBgkqhkiG9w0BAQUFAASCAQCBbPsVYJtaqHq2
// SIG // hX6WnQAQFAyn3XJKzYQ3nrmd33MORbcXBJe8RbP1YN7z
// SIG // iQWXLK+kxRr+Mzh2FDE8SdEYjh2SeTufK0qbUhUEZzeI
// SIG // X4daQc3MTKVfudQRBJz5ofWD1idA9OOrgF5izVXrlArz
// SIG // TCFE8v4yNuizjcTlC3U+lhiAA5PZLZ/nGzX6j0/u3SGF
// SIG // GRWLR1kA5BpvB2Z9n40DlMrofIOvyEF0gveHC7iEfPM0
// SIG // zBluczr1y3ekv475ZUC3EmLd86qQxGCY3H/WF7bBC8zB
// SIG // EEZV0BMKPyoNNVqhrsJwKXTInTSovqCG2ZUCLVHEoRfm
// SIG // 7OX1Exgn5g0gbiAmLE1T
// SIG // End signature block
